package labirinto;

/**
 * È l'istanza di stanza che contiene i tutti tipi di mura. Le proprietà
 * particolari data una stanza delle mura vengono definite in Labirinto.
 * 
 * @author koelio
 * @see Labirinto qui vengono definite le mura per il percorso del labirinto
 */
public class Stanza {
	private Muro[] mura = new Muro[4];
	private boolean victory = false;
	
	
	// tipi di mura
	public enum Mura {
		
		MURO(new Muro(new int[]{0,0}, 1)), PORTA(new Muro(new int[]{0,0}, 2)), BARATRO(new Muro(new int[]{0,0}, 3)), PASSAGGIO(
				new Muro(new int[]{0,0}, 4));

		private Muro muro;

		private Mura(Muro muro) {
			this.muro = muro;
		}

		private Muro getMuro() {
			return muro;
		}

	}

	// serve per generare i muri
	public void creaMura(String tipo1, String tipo2, String tipo3, String tipo4) {
		Muro[] mura = new Muro[4];

		mura[0] = Mura.valueOf(tipo1).getMuro().clone();
		mura[1] = Mura.valueOf(tipo2).getMuro().clone();
		mura[2] = Mura.valueOf(tipo3).getMuro().clone();
		mura[3] = Mura.valueOf(tipo4).getMuro().clone();
		this.mura = mura;
	}

	// serve per confrontare il tipo di muro dove si cerca di andare
	public Muro[] getMura() {
		return this.mura;
	}
	
	public boolean checkVictory(){
		return this.victory;
	}
	
	public void setVictory(boolean victory){
		this.victory = victory;
	}
}
